/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.property.base;

import filenet.vw.api.VWParticipant;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.property.base.VWConfigSecurityPane;
import filenet.vw.toolkit.admin.resources.VWResource;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWKeyAdapter;
import filenet.vw.toolkit.utils.VWMouseAdapter;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.images.VWBaseImageLoader;
import filenet.vw.toolkit.utils.images.VWImageLoader;
import filenet.vw.toolkit.utils.table.VWParticipantItem;
import filenet.vw.toolkit.utils.table.VWSortedListModel;
import filenet.vw.toolkit.utils.uicontrols.security.VWItemFilterPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;

public class VWConfigFilteredSecurityPanel
extends VWConfigSecurityPane
implements ActionListener,
FocusListener {
    protected int m_nType = 0;
    protected JRadioButton m_groupsRadioButton;
    protected JRadioButton m_usersRadioButton;
    protected VWItemFilterPanel m_itemFilterPanel;

    public VWConfigFilteredSecurityPanel(Container parentContainer, VWSessionInfo sessionInfo, VWParticipant[] readRight, VWParticipant[] otherRight, int secType) {
        super(parentContainer, sessionInfo, readRight, otherRight, secType);
        this.m_enableTypeAhead = false;
        this.setAvailableItemName(VWResource.s_availableUsers);
        this.setSelectedItemName(VWResource.s_selectedUsers);
        if (this.m_removeButton != null && this.m_selectedLabel != null) {
            VWAccessibilityHelper.setAccessibility(this.m_removeButton, this, this.m_selectedLabel.getText() + this.m_removeButton.getAccessibleContext().getAccessibleName(), this.m_selectedLabel.getText() + this.m_removeButton.getAccessibleContext().getAccessibleName());
        }
        if (this.m_availableList != null && this.m_availableLabel != null) {
            VWAccessibilityHelper.setLabelFor(this.m_availableLabel, this.m_availableList);
            VWAccessibilityHelper.setAccessibility(this.m_availableList, this, this.m_availableLabel.getText(), this.m_availableLabel.getText());
        }
        if (this.m_selectedList != null && this.m_selectedLabel != null) {
            VWAccessibilityHelper.setLabelFor(this.m_selectedLabel, this.m_selectedList);
            VWAccessibilityHelper.setAccessibility(this.m_selectedList, this, this.m_selectedLabel.getText(), this.m_selectedLabel.getText());
        }
    }

    public void releaseResources() {
        if (this.m_groupsRadioButton != null) {
            this.m_groupsRadioButton.removeActionListener(this);
            this.m_groupsRadioButton = null;
        }
        if (this.m_usersRadioButton != null) {
            this.m_usersRadioButton.removeActionListener(this);
            this.m_usersRadioButton = null;
        }
        super.releaseResources();
    }

    public void actionPerformed(ActionEvent event) {
        try {
            if (event.getSource().equals(this.m_groupsRadioButton)) {
                if (this.m_nType != 1 && this.m_itemFilterPanel != null) {
                    this.m_itemFilterPanel.clear();
                }
                this.m_nType = 1;
                this.updateAvailableList(null);
            } else if (event.getSource().equals(this.m_usersRadioButton)) {
                if (this.m_nType != 0 && this.m_itemFilterPanel != null) {
                    this.m_itemFilterPanel.clear();
                }
                this.m_nType = 0;
                this.updateAvailableList(null);
            } else if (event.getSource().equals(this.m_itemFilterPanel)) {
                switch (this.m_nType) {
                    case 0: {
                        this.updateAvailableList(this.m_itemFilterPanel.getUserParticipantItems());
                        break;
                    }
                    case 1: {
                        this.updateAvailableList(this.m_itemFilterPanel.getGroupParticipantItems());
                    }
                }
            } else {
                super.actionPerformed(event);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            JOptionPane.showMessageDialog(this.m_parentContainer, ex.getLocalizedMessage(), VWResource.s_error, 0);
        }
    }

    protected void addControls() {
        try {
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.anchor = 23;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.gridwidth = 3;
            gbCons.gridheight = 1;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(3, 3, 3, 3);
            JPanel headerPanel = this.getHeaderPanel();
            this.add((Component)headerPanel, gbCons);
            JPanel panel = new JPanel();
            this.m_itemFilterPanel = new VWItemFilterPanel(this.m_parentContainer, this.m_vwSession);
            this.m_itemFilterPanel.addActionListener(this);
            this.m_itemFilterPanel.requestFocus();
            this.m_availableList = new JList(new VWSortedListModel());
            this.m_availableList.addListSelectionListener(this);
            this.m_availableList.addMouseListener(new VWMouseAdapter(this));
            JScrollPane availableListPane = new JScrollPane(this.m_availableList);
            this.m_availableList.addKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_availableList.addFocusListener(this);
            panel.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 23;
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridheight = 1;
            gbc.gridwidth = 1;
            gbc.fill = 0;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            gbc.insets = new Insets(3, 3, 3, 3);
            panel.add((Component)this.m_availableLabel, gbc);
            VWAccessibilityHelper.setAccessibility(this.m_availableLabel, this, this.m_availableLabel.getText(), this.m_availableLabel.getText());
            this.m_availableLabel.addKeyListener(VWKeyAdapter.s_keyAdapter);
            VWAccessibilityHelper.setLabelFor(this.m_availableLabel, this.m_availableList);
            ++gbc.gridy;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            panel.add((Component)this.m_itemFilterPanel, gbc);
            ++gbc.gridy;
            gbc.fill = 1;
            gbc.weighty = 1.0;
            panel.add((Component)availableListPane, gbc);
            gbCons.gridwidth = 2;
            gbCons.gridheight = 3;
            ++gbCons.gridy;
            gbCons.fill = 1;
            gbCons.weighty = 1.0;
            gbCons.weightx = 0.5;
            this.add((Component)panel, gbCons);
            gbCons.anchor = 10;
            gbCons.gridx += gbCons.gridwidth;
            gbCons.gridwidth = 1;
            gbCons.fill = 3;
            gbCons.weightx = 0.0;
            this.add((Component)this.createAddRemoveButtonPanel(), gbCons);
            ++gbCons.gridx;
            ++gbCons.gridy;
            gbCons.gridwidth = 2;
            gbCons.gridheight = 3;
            gbCons.fill = 1;
            gbCons.weightx = 0.5;
            gbCons.weighty = 1.0;
            this.m_selectedList = new JList(new VWSortedListModel());
            this.m_selectedList.addListSelectionListener(this);
            this.m_selectedList.addMouseListener(new VWConfigSecurityPane.SecurityPaneMouse(this));
            this.m_selectedList.addFocusListener(this);
            this.add((Component)this.createSelectedListPanel(this.m_selectedList), gbCons);
            this.m_selectedList.addKeyListener(VWKeyAdapter.s_keyAdapter);
            VWAccessibilityHelper.setLabelFor(this.m_selectedLabel, this.m_selectedList);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected JPanel getHeaderPanel() {
        try {
            JPanel headerPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.anchor = 21;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.gridheight = 1;
            gbCons.gridwidth = 1;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(3, 3, 0, 2);
            JLabel showAvailableLabel = new JLabel(VWResource.s_showAvailableColon);
            headerPanel.add((Component)showAvailableLabel, gbCons);
            VWAccessibilityHelper.setLabelFor(showAvailableLabel, headerPanel);
            showAvailableLabel.addKeyListener(VWKeyAdapter.s_keyAdapter);
            ++gbCons.gridx;
            gbCons.insets = new Insets(0, 3, 0, 0);
            this.m_usersRadioButton = new JRadioButton(VWResource.s_Users);
            this.m_usersRadioButton.setSelected(true);
            this.m_usersRadioButton.addActionListener(this);
            ButtonGroup filterGroup = new ButtonGroup();
            headerPanel.add((Component)this.m_usersRadioButton, gbCons);
            VWAccessibilityHelper.setMemberOf(this.m_usersRadioButton, filterGroup);
            VWAccessibilityHelper.setLabelFor(showAvailableLabel, this.m_usersRadioButton);
            this.m_usersRadioButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            ++gbCons.gridx;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            this.m_groupsRadioButton = new JRadioButton(VWResource.s_Groups);
            this.m_groupsRadioButton.addActionListener(this);
            headerPanel.add((Component)this.m_groupsRadioButton, gbCons);
            VWAccessibilityHelper.setMemberOf(this.m_groupsRadioButton, filterGroup);
            VWAccessibilityHelper.setAccessibility(this.m_groupsRadioButton, headerPanel, VWResource.s_Groups, VWResource.s_Groups);
            VWAccessibilityHelper.setLabelFor(showAvailableLabel, this.m_groupsRadioButton);
            this.m_groupsRadioButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            return headerPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    protected JPanel createAddRemoveButtonPanel() {
        try {
            JPanel panel = new JPanel(new GridBagLayout());
            GridBagConstraints gbConst = new GridBagConstraints();
            gbConst.anchor = 10;
            gbConst.fill = 0;
            gbConst.gridx = 0;
            gbConst.gridy = -1;
            gbConst.gridwidth = 1;
            gbConst.gridheight = 1;
            gbConst.weightx = 0.0;
            gbConst.weighty = 0.0;
            gbConst.insets = new Insets(3, 0, 3, 0);
            if (this.m_bShowMoveAllButtons) {
                this.m_addAllButton = new JButton(VWImageLoader.createImageIcon("addall.gif"));
                this.m_addAllButton.setDisabledIcon(VWImageLoader.createImageIcon("addall_d.gif"));
                this.m_addAllButton.setToolTipText(VWResource.s_addAll);
                this.m_addAllButton.setName("m_addAllButton_VWConfigFilteredUsersPanel");
                this.m_addAllButton.setMargin(new Insets(1, 1, 1, 1));
                this.m_addAllButton.addActionListener(this);
                VWBaseImageLoader.enableIconComponentOrientation(this.m_addAllButton);
                VWAccessibilityHelper.setAccessibility(this.m_addAllButton, this, VWResource.s_addAll, VWResource.s_addAll);
                this.m_addAllButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
                panel.add((Component)this.m_addAllButton, gbConst);
            }
            this.m_addButton = new JButton(VWImageLoader.createImageIcon("add.gif"));
            this.m_addButton.setDisabledIcon(VWImageLoader.createImageIcon("add_d.gif"));
            this.m_addButton.setToolTipText(VWResource.s_add);
            this.m_addButton.setName("m_addButton_VWConfigFilteredUsersPanel");
            this.m_addButton.setMargin(new Insets(1, 1, 1, 1));
            this.m_addButton.addActionListener(this);
            VWBaseImageLoader.enableIconComponentOrientation(this.m_addButton);
            VWAccessibilityHelper.setAccessibility(this.m_addButton, this, VWResource.s_add, VWResource.s_add);
            this.m_addButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            panel.add((Component)this.m_addButton, gbConst);
            gbConst.fill = 2;
            gbConst.insets = new Insets(60, 4, 4, 4);
            JLabel label = new JLabel(VWResource.s_label.toString(VWResource.DefaultRights));
            panel.add((Component)label, gbConst);
            gbConst.insets = new Insets(0, 0, 0, 0);
            VWAccessibilityHelper.setAccessibility(label, this, VWResource.DefaultRights, VWResource.DefaultRights);
            label.addKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_queryRightCheckBox = new JCheckBox(VWResource.Query);
            this.m_queryRightCheckBox.addActionListener(this);
            panel.add((Component)this.m_queryRightCheckBox, gbConst);
            VWAccessibilityHelper.setAccessibility(this.m_queryRightCheckBox, this, VWResource.DefaultRights + VWResource.Query, VWResource.DefaultRights + VWResource.Query);
            VWAccessibilityHelper.setLabelFor(label, this.m_queryRightCheckBox);
            this.m_queryRightCheckBox.addKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_otherRightCheckBox = new JCheckBox(VWResource.Process);
            this.m_otherRightCheckBox.addActionListener(this);
            panel.add((Component)this.m_otherRightCheckBox, gbConst);
            VWAccessibilityHelper.setAccessibility(this.m_otherRightCheckBox, this, VWResource.DefaultRights + VWResource.Process, VWResource.DefaultRights + VWResource.Process);
            VWAccessibilityHelper.setLabelFor(label, this.m_otherRightCheckBox);
            this.m_otherRightCheckBox.addKeyListener(VWKeyAdapter.s_keyAdapter);
            return panel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    protected JPanel createSelectedListPanel(JList selectedList) {
        try {
            JPanel sListPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.anchor = 21;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.gridheight = 1;
            gbCons.gridwidth = 1;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(3, 3, 0, 2);
            sListPanel.add((Component)this.m_selectedLabel, gbCons);
            VWAccessibilityHelper.setAccessibility(this.m_selectedLabel, this, this.m_selectedLabel.getText(), this.m_selectedLabel.getText());
            ++gbCons.gridx;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            this.m_removeButton = VWImageLoader.createToolBarButton("delete.gif", VWResource.s_delete, false);
            this.m_removeButton.addActionListener(this);
            sListPanel.add((Component)this.m_removeButton, gbCons);
            VWAccessibilityHelper.setAccessibility(this.m_removeButton, this, VWResource.s_delete, VWResource.s_delete);
            --gbCons.gridx;
            ++gbCons.gridy;
            gbCons.gridwidth = 2;
            gbCons.fill = 1;
            gbCons.weightx = 1.0;
            gbCons.weighty = 1.0;
            sListPanel.add((Component)new JScrollPane(selectedList), gbCons);
            VWAccessibilityHelper.setLabelFor(this.m_selectedLabel, selectedList);
            ++gbCons.gridy;
            gbCons.fill = 2;
            gbCons.weighty = 0.0;
            this.m_allUserPermissionLabel = new JLabel();
            sListPanel.add((Component)this.m_allUserPermissionLabel, gbCons);
            VWAccessibilityHelper.setAccessibility(this.m_allUserPermissionLabel, this, this.m_allUserPermissionLabel.getText(), this.m_allUserPermissionLabel.getText());
            this.m_allUserPermissionLabel.addKeyListener(VWKeyAdapter.s_keyAdapter);
            return sListPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    protected VWConfigSecurityPane.ConfigAccessSecurity[] createAvailableAccessList(VWConfigSecurityPane.ConfigAccessSecurity[] selectedItems) {
        return null;
    }

    protected void updateAvailableList(VWParticipantItem[] vwParticipantItems) {
        try {
            Object[] availableItems = null;
            Object[] selectedItems = this.getSelectedItems();
            if (vwParticipantItems != null && vwParticipantItems.length > 0) {
                Vector<VWConfigSecurityPane.ConfigAccessSecurity> items = new Vector<VWConfigSecurityPane.ConfigAccessSecurity>();
                for (int i = 0; i < vwParticipantItems.length; ++i) {
                    VWConfigSecurityPane.ConfigAccessSecurity aEle = new VWConfigSecurityPane.ConfigAccessSecurity(vwParticipantItems[i].getVWParticipant(), 0);
                    items.addElement(aEle);
                }
                if (items.size() > 0) {
                    availableItems = new VWConfigSecurityPane.ConfigAccessSecurity[items.size()];
                    items.copyInto(availableItems);
                }
            }
            this.initializeLists(availableItems, selectedItems);
            this.fireListUpdatedEvent(5, availableItems);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected Object[] onRemoveItemsAction(Object[] items) {
        return null;
    }

    public void focusGained(FocusEvent e) {
        int[] indices;
        JList list;
        Object source = e.getSource();
        if (source != null && source instanceof JList && (list = (JList)source).getModel().getSize() > 0 && ((indices = list.getSelectedIndices()) == null || indices.length == 0)) {
            list.setSelectedIndex(0);
        }
    }

    public void focusLost(FocusEvent e) {
        Object source = e.getSource();
    }
}

